function PRESS = calculate_PRESS(X, y, n_components, n_folds)

    % Divide data into folds
    cv = cvpartition(size(X, 1), 'KFold', n_folds);

    % Initialize PRESS
    PRESS = 0;

    % Cross-validation loop
    for i = 1:cv.NumTestSets

        % Training and testing sets
        trainIdx = cv.training(i);
        testIdx = cv.test(i);

        % Train PLS-DA model
        pls = plsregress(X(trainIdx,:), y(trainIdx), n_components);

        % Predict on test set
        y_pred = predict(pls, X(testIdx,:));

        % Calculate residuals
        residuals = y(testIdx) - y_pred;

        % Update PRESS
        PRESS = PRESS + sum(residuals.^2);

    end

end